//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Non-RAD Aged Care Wealth
// Objective: 	Estimating the value of wealth held by aged care residents in
//				2018.
//
// Created: 	06/09/2021
// Modified: 	15/11/2021
//==============================================================================

clear all	// clearing the workspace

cd "XXXX"	// set content directory here

use HILDA_restricted_combined_rescaled.dta, replace	// opening the dataset

keep if wave == 18	// keeping 2018 observations

keep if dodtyp == 1	// keeping only aged care residents

g ep_net_worth = pwassei - pwdebti	// generating an enumerated person net worth variable
g wt_ep_net_worth = ep_net_worth * benchmarked_new_hhwte	// applying the population-level enumerated person weights to the net worth variable

collapse(sum) wt_ep_net_worth, by(year)	// collapsing the dataset by year